VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form frmMain 
   Caption         =   "Thermocouples and DriverLINX"
   ClientHeight    =   7560
   ClientLeft      =   2460
   ClientTop       =   1725
   ClientWidth     =   6345
   LinkTopic       =   "Form1"
   ScaleHeight     =   7560
   ScaleWidth      =   6345
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   390
      Left            =   450
      TabIndex        =   15
      Top             =   5325
      Width           =   1740
   End
   Begin VB.Frame Frame3 
      Caption         =   "Channel Mode"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   840
      Left            =   450
      TabIndex        =   11
      Top             =   2175
      Width           =   1965
      Begin VB.OptionButton optChanMode 
         Caption         =   "Differential"
         Height          =   240
         Left            =   150
         TabIndex        =   13
         Top             =   225
         Value           =   -1  'True
         Width           =   1440
      End
      Begin VB.OptionButton Option1 
         Caption         =   "Single Ended"
         Height          =   195
         Left            =   150
         TabIndex        =   12
         Top             =   525
         Width           =   1515
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "T/C Channel"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   840
      Left            =   450
      TabIndex        =   10
      Top             =   1125
      Width           =   1965
      Begin VB.ComboBox cboTCChan 
         Height          =   315
         Left            =   300
         TabIndex        =   14
         Text            =   "Combo2"
         Top             =   300
         Width           =   615
      End
   End
   Begin VB.CommandButton cmdHelp 
      Caption         =   "Help"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   390
      Left            =   450
      TabIndex        =   9
      Top             =   5925
      Width           =   1725
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   390
      Left            =   450
      TabIndex        =   8
      Top             =   6525
      Width           =   1725
   End
   Begin VB.Frame Frame1 
      Caption         =   "Thermocouple Type"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   855
      Left            =   450
      TabIndex        =   6
      Top             =   3225
      Width           =   2010
      Begin VB.ComboBox Combo1 
         Height          =   315
         Left            =   240
         TabIndex        =   7
         Text            =   "J"
         Top             =   300
         Width           =   630
      End
   End
   Begin VB.ListBox List1 
      Height          =   5130
      Left            =   2880
      TabIndex        =   3
      Top             =   1680
      Width           =   2760
   End
   Begin DlsrLib.DriverLINXSR SRAI 
      Left            =   5475
      Top             =   750
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   390
      Left            =   450
      TabIndex        =   1
      Top             =   4725
      Width           =   1725
   End
   Begin VB.Label Label3 
      BackColor       =   &H00FFFFFF&
      Caption         =   "Temperature at the CJC sensor (chan 0)"
      Height          =   255
      Left            =   2880
      TabIndex        =   5
      Top             =   240
      Width           =   3015
   End
   Begin VB.Label Label2 
      Caption         =   "Temperature (degC) at TC Channel"
      Height          =   255
      Left            =   2880
      TabIndex        =   4
      Top             =   1320
      Width           =   2535
   End
   Begin VB.Label lblCJCTemp 
      BackColor       =   &H00FFFFFF&
      Height          =   375
      Left            =   2880
      TabIndex        =   2
      Top             =   600
      Width           =   1095
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   435
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   2085
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' this example was written for high gain KPCI Series boards such as KPCI-1801HC or
' KPCI-3107 or KPCI-3108.  It demonstrates how to get temperature from a thermocouple.
'
' A KPCI-1801HC with kpci1800-850A03 version of DriverLINX was used.
'
' Assumes the CJC sensor is feed into analog input channel 0.
' Assumes the T/C is feed into analog input channel 1 or higher
'
' programs the KPCI board for a gain of 50 which is suitable for KPCI-1801HC;
' For KPCI-3107 or KPCI-3108 use other gains suited for those boards
'
' use of Single Ended or Differential channels is controllable from the code
' at the gainCode property.  This is feature of KPCI boards.
'
'  This example uses BURST mode to quickly take 10 samples from a channel.  These
'  quick bursts are repeated at a slower rate of 1KHz.  At 1 msec intervals (1KHz) a
'  new burst of 10 samples are acquired.  The 10 samples acquired at
'  the faster burst rate are averaged together and reported as a single value.
'
'  The buffer size is set to a larger number such as 250 samples so that the
'  buffer filled message rate is not faster than is practical for Windows message
'  processing rates.  A buffer size of 250 samples means a buffer will be filled each
'  25 msec.  In the Buffer Filled event procedure, a nested loop is used to sort the
'  250 data points into 25 groups of 10 samples each and report a single averaged value
'  for each burst (group of 10) of data.
'
Dim ChanMode As Single  ' use this to control SE or Diff mode
' for TC reference Lib
Dim linearizer As New TCLinearizer  ' declare instance of the TCLibrary object
Dim calculatedTemp As Single
Dim TCvolts As Double
Dim CJCTemp As Double

Private Sub cmdExit_Click()
' stop any task that could be active
SRAI.Req_op = DL_STOP
SRAI.Refresh
Form_Unload 0  ' call the code to unload the drivers
End
End Sub

Private Sub cmdHelp_Click()
frmAbout.Show
End Sub


Private Sub cmdStart_Click()

' determine if Single Ended or Differential is selected
If optChanMode.Value = True Then
    ChanMode = 3 * 2 ^ 13  ' differential
Else
    ChanMode = 2 * 2 ^ 13  ' single ended
    ' ChanMode = 0 means use the setting in the DLinx Config Panel
    '
    ' differential mode gives better common mode rejection for noise immunity than SE
End If

SampleCJCSensor
Debug.Print SRAI.DLCode2Volts(SRAI.Res_Sta_ioValue)
CJCTemp = SRAI.DLCode2Volts(SRAI.Res_Sta_ioValue) / (0.01) ' in volts
' CJC on most accessories is 10 mV per deg C
lblCJCTemp.Caption = Str(Round(CJCTemp, 2)) & " deg C"

' now start reading the T/C sensor
SetUpBurstModeAI

' DriverLINX for KPCI boards will install a newer thermcp.dll than what the
' DriverLINX for an ISA board will give you.  The old one distributed with
' ISA boards has a bug in it.  You can download the TCLibrary object from
' the Keithley web site
End Sub


Private Sub cmdStop_Click()
With SRAI
    .Req_op = DL_STOP
    .Refresh
End With
End Sub

Private Sub Form_Load()
Dim i As Integer
' populate the combo box with the supported T/C types
Combo1.AddItem "K"
Combo1.AddItem "J"
Combo1.AddItem "T"
Combo1.AddItem "S"
Combo1.AddItem "B"
Combo1.AddItem "E"
Combo1.AddItem "R"
Combo1.AddItem "C"
Combo1.AddItem "N"
' set the combo box equal to the first entry
Combo1.ListIndex = 0

'populate channel select combo box with values of 1 through 7
For i = 1 To 7
cboTCChan.AddItem Str(i), i - 1
Next i
cboTCChan.ListIndex = 1 ' set it equal to an entry

' open driver and init the hardware
SRAI.Req_DLL_name = "kpci1800"  ' substitute kpci3108 for KPCI-3107 or KPCI-3108
With SRAI
.Req_device = 0  ' device number assigned in DLinx Config Panel
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With

With SRAI
.Req_op = DL_MESSAGEBOX  ' will pop up message box if an error condition exists
.Refresh
End With

End Sub

Private Sub Form_Terminate()
Beep
End Sub

Private Sub Form_Unload(Cancel As Integer)
' unload the driver for SR control
SRAI.Req_DLL_name = ""
End Sub

Public Sub SampleCJCSensor()
    'set up polled mode AI task
With SRAI
.Req_mode = DL_POLLED
.Req_op = DL_START
.Req_subsystem = DL_AI
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_TCEVENT
.Evt_Tim_type = DL_NULLEVENT
.Sel_buf_N = 0
.Sel_chan_N = 1  ' single channel; so need only start channel
' read the CJC channel which is jumpered to feed channel 0
.Sel_chan_start = 0  ' read channel 0
.Sel_chan_startGainCode = .DLGain2Code(-1) '+ ChanMode ' control channel mode from code
' the negative sign means bipolar range; the 1 means gain of 1
' Have the board sample the CJC twice below:
.Refresh  ' take a dummy polled mode sample and throw it away
.Refresh  ' seems to be a bug when mixing paced and polled mode AI.  Need to take a dummy sample
End With  ' in the polled mode task to get good data reliably from the CJC channel.
End Sub

Public Sub SetUpBurstModeAI()
Dim i As Integer
With SRAI
' request grouo
.Req_mode = DL_DMA
.Req_op = DL_START
.Req_subsystem = DL_AI
' events group
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_COMMAND
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = DL_DEFAULTTIMER  ' each board has default timing channel
.Evt_Tim_rateClock = DL_INTERNAL1       ' internal1 timebase
.Evt_Tim_rateGate = DL_NOCONNECT   ' no gating
.Evt_Tim_rateMode = DL_BURSTGEN     ' burst all channels at each tic of clock
.Evt_Tim_rateOnCount = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 50000) ' 50KHz burst rate
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 1000) '1KHz rate = new burst of data every 1 msec
.Evt_Tim_ratePulses = 10  ' must be equal to number of channels in the chan/gain list
' select group
.Sel_buf_N = 10
.Sel_buf_samples = 250 ' 250 samples = 25 bursts = 25 msec buffer filled message interval
.Sel_buf_notify = DL_NOTIFY ' send buffer filled messages
' program a channel/gain list with the value of our selected TC channel
' this allows us to redundantly sample the same channel....need to do some signal
' averaging to get a decent T/C measurement from a plug-in board
.Sel_chan_N = 10
For i = 0 To .Sel_chan_N - 1
.Sel_chan_list(i) = cboTCChan.ListIndex + 1
.Sel_chan_gainCodeList(i) = .DLGain2Code(-50) + ChanMode
Next i
' in the gain, the negative sign means bipolar range; the 50 means gain of 50 + SE or Diff mode.
' if only going into positive temperatures, could use unipolar range, e.g., +50
.Refresh  ' start the task
End With
End Sub

Private Sub SRAI_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)

    List1.Clear
    
    Dim result As Long
    Dim AIData(250) As Single  ' buffer contains 250 samples or 25 bursts
    Dim AvgTCvolts As Single
    Dim i, stepOffset As Integer
    ' convert the buffer of data...move from memory to array and convert to volts
    result = SRAI.VBArrayBufferConvert(bufIndex, 0, 250, AIData(), DL_tSINGLE, 0, 0)
    ' calculate an average value from each burst of data in the buffer
For stepOffset = 0 To 249 Step 10
        AvgTCvolts = 0  ' initialize value on entry
          For i = 0 To 9  ' grab 10 values from a burst
            AvgTCvolts = AvgTCvolts + AIData(stepOffset + i) ' use offset to deal with burst groups
          Next i
    AvgTCvolts = AvgTCvolts / 10  ' compute their average value
    ' call a function in the thermcp object......
    calculatedTemp = linearizer.TCLinearizeValue(Asc(Combo1.Text), _
                                                 TableCJC, _
                                                 Volts2Temp, _
                                                 Celsius, _
                                                 CJCTemp, _
                                                 AvgTCvolts) ' calculate temperature from this avg Value
     ' TCLinearizer has methods to convert arrays too, not just single values
     List1.AddItem "Measured Temp: " & Str(Format(calculatedTemp, "###.0#")) ' display temperature
Next stepOffset


End Sub

Private Sub SRAI_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
MsgBox "Data Lost due to buffer over run has occured.  Please increase the size and/or number of buffers", vbCritical, "Whoops!"
End Sub
